library('deSolve')

# define derivative function for ode()
dSdt <- function(t, S, parms)
  list(with(parms,lambda_max*(1-S/S_M)-k*S))

# set up model parameters
parms = list(lambda_max=0.1,S_M=1000,k=0.001)
ts = seq(0,4000,length.out=100)
S0 = 0

# run ode()
temp = ode(S0,ts,dSdt,parms)

# plot the results
plot(temp[,1],temp[,2],type='l',xlab='t',ylab='S')

# plot the analytical solution for S vs. t
S_eq = with(parms,lambda_max/(k+lambda_max/S_M))
S_t = with(parms,S_eq*(1-(1-S0/S_eq)*
                 exp(-(k+lambda_max/S_M)*ts)))
lines(ts,S_t,col='red')

# plot the equilibrium species richness
abline(h=S_eq,lty=2)

# plot the half life
t_half = with(parms,log(2)/(k+lambda_max/S_M))
abline(v=t_half,lty=3)
abline(h=S0+(S_eq-S0)/2,lty=3) 
